function nn = nnbp(nn)
%NNBP performs backpropagation
% nn = nnbp(nn) returns an neural network structure with updated weights 
    
    n = nn.n;
    sparsityError = 0;

    [mm,mmm] = size(nn.a{2});
    [ww,www] = size(nn.W{2});

    switch nn.output
        case 'sigm'
            d{n} = - nn.e .* (nn.a{n} .* (1 - nn.a{n}));
        case {'softmax','linear'}
            d{n} = - nn.e;
    end
    for i = (n - 1) : -1 : 2
        % Derivative of the activation function
        switch nn.activation_function 
            case 'sigm'
                %d_act = (sign(nn.a{i}) +1)/2;
                d_act = nn.a{i}.*(1-nn.a{i});
            case 'tanh_opt'
                d_act = 1.7159 * 2/3 * (1 - 1/(1.7159)^2 * nn.a{i}.^2);
        end
        
        if(nn.nonSparsityPenalty>0)
            pi = repmat(nn.p{i}, size(nn.a{i}, 1), 1);
            sparsityError = [zeros(size(nn.a{i},1),1) nn.nonSparsityPenalty * (-nn.sparsityTarget ./ pi + (1 - nn.sparsityTarget) ./ (1 - pi))];
        end

        %sparsityError = 0;
        
        % Backpropagate first derivatives
        if i+1==n % in this case in d{n} there is not the bias term to be removed             
            d{i} = (d{i + 1} * nn.W{i} + sparsityError) .* d_act; %( Bishop (5.56)

            %d{i} = d{i + 1} * nn.W{i} + sparsityError;
        end
                   % in this case in d{i} the bias term has to be removed
        if i==2
            %da2 = (sign(nn.p{i}) +1)/2;
            %da2 = nn.p{i} .* (1 - nn.p{i});
            %da1 = (sign(nn.a{i}) +1)/2;
            da1 = nn.a{i+1} .* (1 - nn.a{i+1});
              
            ww = nn.ww;

            vv1 = ww(:,1);
            vv2 = ww(:,2:end);

            vv2 = vv2';
            ww = [vv1,vv2];
            
            %ww = nn.W{i};
            pp = d{i+1};

            for k = 1:mm 

                daa = da1(k,:);
                z_G = pp(:,2:end);
                options = optimset('TolFun',0.0001);

                alpha = nn.weightPenaltyL1;
                wii = nn.Wii;

                mx = max(nn.wflag);
                [Wii1,Wii2] = size(nn.Wii);

                 z = zeros(1,Wii2);
                 zc = cell(mx);

                 if exist('gpuDevice', 'var')
                        gpuDevice = gpuDevice();
                 end
                 parfor mi = 1:mx
                 %for mi = 1:mx
                     %disp(mi);
                     mvec = [0];
                     mpp = [1];
                     mdaa = daa(1,1);
                     [pp1,pp2] = size(nn.wflag);

                     mcol = [];
                     miol = [];
                     for mj = 1:pp2
                         if mi == nn.wflag(1,mj)
                             mvec = [mvec,mj];
                             mpp = [mpp,pp(1,mj+1)];
                             mdaa = [mdaa,daa(1,mj+1)];
                             mcol = [mcol;ww(mj,1)];
                             miol = [miol,wii(mj,1)];
                         end
                      end
                      %mpp = [1,mpp];
                      mvec(:,1) = [];
                      %mpp(:,1) = [];

                      [mc1,mc2] = size(mvec);
                      mww = zeros(mc2,mc2);
                      mwii = zeros(mc2,mc2);
                            
                      for mj = 1:mc2
                          for mk = 1:mc2
                               mww(mj,mk) = ww(mvec(1,mj), mvec(1,mk)+1);
                               mwii(mj,mk) = wii(mvec(1,mj)+1, mvec(1,mk));
                          end
                      end

                      mww = [mcol, mww];
                      mwii = [miol; mwii];

                      mz_G = mpp(:,2:end);
                      mz = fsolve(@(xx)root8d(xx,mpp,mww,mdaa,alpha,mwii), mz_G, options);
                            
                      %for mj = 1:mc2
                      %     z(1,mvec(1,mj)) = mz(1,mj);
                      %end
                      zc{mi} = mz;
                 end

                 zc = gather(zc); 

                 for mi = 1:mx
                     mvec = [0];
                     [pp1,pp2] = size(nn.wflag);

                     for mj = 1:pp2
                         if mi == nn.wflag(1,mj)
                             mvec = [mvec,mj];
                         end
                     end
                     mvec(:,1) = [];
                     [mc1,mc2] = size(mvec);

                     for mj = 1:mc2
                         mz = zc{mi};
                         z(1,mvec(1,mj)) = mz(1,mj);
                     end
                 end
                % = fsolve(@(xx)root8d(xx,pp,ww,da1(k,:),alpha,wii), z_G, options);
                %nn.a{i}(k,:) = sigm(z);pp
                disp(k );
                disp(i);

                %d{i}(k,2:mmm) = z.*da1(1,2:mmm);
                d{i}(k,2:mmm) = z;
            end

            %if i == 3
                %nn.a{i} = nn.a{i} + nn.weightPenaltyL1 * sum(abs(nn.W{i - 1}')) + 1.0000e-08 * sum(abs(nn.W{i-1}') .* connect(nn.W{i-1}'));
                %[Wii, wflag] = connect_module2(abs(nn.W{i-1}'));
                %nn.Wii = connect_value(abs(nn.W{i-1}'), Wii, wflag);
                %nn.wflag = wflag;

                %nn.Wii = connect_module6(abs(nn.W{i-1}'));
                %nn.a{i} = nn.a{i} + nn.alpha * sum(abs(nn.W{i-1}') .* nn.Wii) + nn.weightPenaltyL1 * sum(abs(nn.W{i-1}')) + nn.weightPenaltyL2 * sum(nn.W{i-1}' .* nn.W{i-1}');
                %nn.a{i} = nn.a{i} + nn.weightPenaltyL1 * sum(abs(nn.W{i - 1}')) + 0 * sum(abs(nn.W{i-1}' .* nn.Wii));
            %else
                %nn.a{i} = nn.a{i} + nn.weightPenaltyL1 * sum(abs(nn.W{i - 1}'));
                %disp('ok');
            %end
        end
        
        if(nn.dropoutFraction>0)
            d{i} = d{i} .* [ones(size(d{i},1),1) nn.dropOutMask{i}];
        end

    end

    for i = 1 : (n - 1)
        if i+1==n
            nn.dW{i} = (d{i + 1}' * nn.a{i}) / size(d{i + 1}, 1);
        else
            if i== 1
                nn.dW{i} = (d{i + 1}(:,2:end)' * nn.a{i}) / size(d{i + 1}, 1); 
            else 
                if i == 2
                    %for j = 1:50
                    %    D = d{i + 1}(:,j+1)';
                    %    A = nn.a{i};
    
                        %D(:,j) = [];
                    %    A(:,j) = zeros(100,1);seros
        
                    %    nn.dW{i}(j,:) = D * A;
                    %end
                    %nn.dW{i} = nn.dW{i} / size(d{i + 1}, 1);
                    disp("bp");
                    disp(i);
    
                    dw1=zeros(www-1,www);
                    for j = 1:www-1
                        for k = 2:www
                            ap = nn.a{i+1};
                            ap(:,k) = zeros(mm,1);

                            dw1(k-1,:) = (d{i}(:,k)' * ap) / size(d{i}, 1);

                        %    if k == 2
                        %        ddw = dw1;
                        %    else
                        %        ddw = [ddw;dw1];
                        %    end
                        end
                    end

                    %ddw = (d{i + 1}(:,2:end)' * nn.a{i}) / size(d{i + 1}, 1); 
                    dw = dw1;

                    for wk=1:www-1
                        dw(wk,wk+1) = 0;
                    end

                    
    
                    %[dw1,dw2] = size(dw);
    
                    %nn.dW{i} = zeros(dw1,dw2);
                    nn.dW{i} = dw;

                    metaWi = nn.Wii;
                    [mw1, mw2] = size(metaWi);
                    Wij = metaWi';
                    %nn.dW{i} = nn.dW{i} + nn.alpha * sign(nn.W{i}) .* Wij + nn.weightPenaltyL1 * sign(nn.W{i}) + nn.weightPenaltyL2 * nn.W{i};
                    %nn.dW{i} = nn.dW{i} + alpha * sign(nn.W{i}).*Wij;
                    nn.dW{i} = nn.dW{i} + alpha * sign(nn.W{i});
                end
            end
        end
    end
end
